/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyFpgaImageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CopyFpgaImageResponse.Builder, CopyFpgaImageResponse> {
    private final String fpgaImageId;

    private CopyFpgaImageResponse(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
    }

    /**
     * <p>
     * The ID of the new AFI.
     * </p>
     * 
     * @return The ID of the new AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFpgaImageResponse)) {
            return false;
        }
        CopyFpgaImageResponse other = (CopyFpgaImageResponse) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(fpgaImageId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CopyFpgaImageResponse> {
        /**
         * <p>
         * The ID of the new AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the new AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);
    }

    static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFpgaImageResponse model) {
            fpgaImageId(model.fpgaImageId);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        @Override
        public CopyFpgaImageResponse build() {
            return new CopyFpgaImageResponse(this);
        }
    }
}
