/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CopyImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyImageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CopyImageRequest.Builder, CopyImageRequest> {
    private final String clientToken;

    private final String description;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String name;

    private final String sourceImageId;

    private final String sourceRegion;

    private CopyImageRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.sourceImageId = builder.sourceImageId;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description for the new AMI in the destination region.
     * </p>
     * 
     * @return A description for the new AMI in the destination region.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the destination snapshots of the copied image should be encrypted. The default CMK for EBS is
     * used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with <code>KmsKeyId</code>. For
     * more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
     * Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the destination snapshots of the copied image should be encrypted. The default CMK for
     *         EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with
     *         <code>KmsKeyId</code>. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when encrypting the snapshots of an image
     * during a copy operation. This parameter is only required if you want to use a non-default CMK; if this parameter
     * is not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace,
     * followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then
     * the CMK ID. For example,
     * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The specified
     * CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code> is specified, the
     * <code>Encrypted</code> flag must also be set.
     * </p>
     * 
     * @return The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when encrypting the snapshots of an
     *         image during a copy operation. This parameter is only required if you want to use a non-default CMK; if
     *         this parameter is not specified, the default CMK for EBS is used. The ARN contains the
     *         <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK
     *         owner, the <code>key</code> namespace, and then the CMK ID. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The
     *         specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code>
     *         is specified, the <code>Encrypted</code> flag must also be set.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the new AMI in the destination region.
     * </p>
     * 
     * @return The name of the new AMI in the destination region.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the AMI to copy.
     * </p>
     * 
     * @return The ID of the AMI to copy.
     */
    public String sourceImageId() {
        return sourceImageId;
    }

    /**
     * <p>
     * The name of the region that contains the AMI to copy.
     * </p>
     * 
     * @return The name of the region that contains the AMI to copy.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageRequest)) {
            return false;
        }
        CopyImageRequest other = (CopyImageRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceImageId(), other.sourceImageId())
                && Objects.equals(sourceRegion(), other.sourceRegion());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (sourceImageId() != null) {
            sb.append("SourceImageId: ").append(sourceImageId()).append(",");
        }
        if (sourceRegion() != null) {
            sb.append("SourceRegion: ").append(sourceRegion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Encrypted":
            return Optional.of(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.of(clazz.cast(kmsKeyId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "SourceImageId":
            return Optional.of(clazz.cast(sourceImageId()));
        case "SourceRegion":
            return Optional.of(clazz.cast(sourceRegion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CopyImageRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description for the new AMI in the destination region.
         * </p>
         * 
         * @param description
         *        A description for the new AMI in the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the destination snapshots of the copied image should be encrypted. The default CMK for EBS
         * is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with <code>KmsKeyId</code>
         * . For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the destination snapshots of the copied image should be encrypted. The default CMK
         *        for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with
         *        <code>KmsKeyId</code>. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when encrypting the snapshots of an image
         * during a copy operation. This parameter is only required if you want to use a non-default CMK; if this
         * parameter is not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code>
         * namespace, followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code>
         * namespace, and then the CMK ID. For example,
         * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The
         * specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code> is
         * specified, the <code>Encrypted</code> flag must also be set.
         * </p>
         * 
         * @param kmsKeyId
         *        The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when encrypting the snapshots of
         *        an image during a copy operation. This parameter is only required if you want to use a non-default
         *        CMK; if this parameter is not specified, the default CMK for EBS is used. The ARN contains the
         *        <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK
         *        owner, the <code>key</code> namespace, and then the CMK ID. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The
         *        specified CMK must exist in the region that the snapshot is being copied to. If a
         *        <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the new AMI in the destination region.
         * </p>
         * 
         * @param name
         *        The name of the new AMI in the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the AMI to copy.
         * </p>
         * 
         * @param sourceImageId
         *        The ID of the AMI to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageId(String sourceImageId);

        /**
         * <p>
         * The name of the region that contains the AMI to copy.
         * </p>
         * 
         * @param sourceRegion
         *        The name of the region that contains the AMI to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private Boolean encrypted;

        private String kmsKeyId;

        private String name;

        private String sourceImageId;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageRequest model) {
            clientToken(model.clientToken);
            description(model.description);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            name(model.name);
            sourceImageId(model.sourceImageId);
            sourceRegion(model.sourceRegion);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceImageId() {
            return sourceImageId;
        }

        @Override
        public final Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public final void setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public CopyImageRequest build() {
            return new CopyImageRequest(this);
        }
    }
}
