/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreatePlacementGroup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePlacementGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreatePlacementGroupRequest.Builder, CreatePlacementGroupRequest> {
    private final String groupName;

    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * A name for the placement group.
     * </p>
     * <p>
     * Constraints: Up to 255 ASCII characters
     * </p>
     * 
     * @return A name for the placement group.</p>
     *         <p>
     *         Constraints: Up to 255 ASCII characters
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public String strategyString() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(strategyString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(strategyString(), other.strategyString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (strategyString() != null) {
            sb.append("Strategy: ").append(strategyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "Strategy":
            return Optional.of(clazz.cast(strategyString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        /**
         * <p>
         * A name for the placement group.
         * </p>
         * <p>
         * Constraints: Up to 255 ASCII characters
         * </p>
         * 
         * @param groupName
         *        A name for the placement group.</p>
         *        <p>
         *        Constraints: Up to 255 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            groupName(model.groupName);
            strategy(model.strategy);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }
    }
}
