/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReservedInstancesListingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateReservedInstancesListingRequest.Builder, CreateReservedInstancesListingRequest> {
    private final String clientToken;

    private final Integer instanceCount;

    private final List<PriceScheduleSpecification> priceSchedules;

    private final String reservedInstancesId;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate
     * listings. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
     *         duplicate listings. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
     * Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance
     * ID specified in this call.
     * </p>
     * 
     * @return The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
     *         Instance Marketplace. This number should be less than or equal to the instance count associated with the
     *         Reserved Instance ID specified in this call.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance
     * term.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
     *         Instance term.
     */
    public List<PriceScheduleSpecification> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * The ID of the active Standard Reserved Instance.
     * </p>
     * 
     * @return The ID of the active Standard Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(priceSchedules(), other.priceSchedules())
                && Objects.equals(reservedInstancesId(), other.reservedInstancesId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (priceSchedules() != null) {
            sb.append("PriceSchedules: ").append(priceSchedules()).append(",");
        }
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "PriceSchedules":
            return Optional.of(clazz.cast(priceSchedules()));
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         * duplicate listings. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         *        duplicate listings. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
         * Marketplace. This number should be less than or equal to the instance count associated with the Reserved
         * Instance ID specified in this call.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
         *        Instance Marketplace. This number should be less than or equal to the instance count associated with
         *        the Reserved Instance ID specified in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceScheduleSpecification... priceSchedules);

        /**
         * <p>
         * The ID of the active Standard Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the active Standard Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Integer instanceCount;

        private List<PriceScheduleSpecification> priceSchedules;

        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            clientToken(model.clientToken);
            instanceCount(model.instanceCount);
            priceSchedules(model.priceSchedules);
            reservedInstancesId(model.reservedInstancesId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<PriceScheduleSpecification.Builder> getPriceSchedules() {
            return priceSchedules != null ? priceSchedules.stream().map(PriceScheduleSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }
    }
}
