/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVpnGatewayRequest.Builder, CreateVpnGatewayRequest> {
    private final String availabilityZone;

    private final String type;

    private final Long amazonSideAsn;

    private CreateVpnGatewayRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.type = builder.type;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    /**
     * <p>
     * The Availability Zone for the virtual private gateway.
     * </p>
     * 
     * @return The Availability Zone for the virtual private gateway.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The type of VPN connection this virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of VPN connection this virtual private gateway supports.
     * @see GatewayType
     */
    public GatewayType type() {
        return GatewayType.fromValue(type);
    }

    /**
     * <p>
     * The type of VPN connection this virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of VPN connection this virtual private gateway supports.
     * @see GatewayType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit ASN, it
     * must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000 to 4294967294
     * range.
     * </p>
     * <p>
     * Default: 64512
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit
     *         ASN, it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000
     *         to 4294967294 range.</p>
     *         <p>
     *         Default: 64512
     */
    public Long amazonSideAsn() {
        return amazonSideAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnGatewayRequest)) {
            return false;
        }
        CreateVpnGatewayRequest other = (CreateVpnGatewayRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(amazonSideAsn(), other.amazonSideAsn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (amazonSideAsn() != null) {
            sb.append("AmazonSideAsn: ").append(amazonSideAsn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "AmazonSideAsn":
            return Optional.of(clazz.cast(amazonSideAsn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpnGatewayRequest> {
        /**
         * <p>
         * The Availability Zone for the virtual private gateway.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The type of VPN connection this virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection this virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection this virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection this virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit ASN,
         * it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000 to
         * 4294967294 range.
         * </p>
         * <p>
         * Default: 64512
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a
         *        16-bit ASN, it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the
         *        4200000000 to 4294967294 range.</p>
         *        <p>
         *        Default: 64512
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String type;

        private Long amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnGatewayRequest model) {
            availabilityZone(model.availabilityZone);
            type(model.type);
            amazonSideAsn(model.amazonSideAsn);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public CreateVpnGatewayRequest build() {
            return new CreateVpnGatewayRequest(this);
        }
    }
}
