/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticGpusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeElasticGpusResponse.Builder, DescribeElasticGpusResponse> {
    private final List<ElasticGpus> elasticGpuSet;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeElasticGpusResponse(BuilderImpl builder) {
        this.elasticGpuSet = builder.elasticGpuSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Elastic GPUs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Elastic GPUs.
     */
    public List<ElasticGpus> elasticGpuSet() {
        return elasticGpuSet;
    }

    /**
     * <p>
     * The total number of items to return. If the total number of items available is more than the value specified in
     * max-items then a Next-Token will be provided in the output that you can use to resume pagination.
     * </p>
     * 
     * @return The total number of items to return. If the total number of items available is more than the value
     *         specified in max-items then a Next-Token will be provided in the output that you can use to resume
     *         pagination.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuSet());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusResponse)) {
            return false;
        }
        DescribeElasticGpusResponse other = (DescribeElasticGpusResponse) obj;
        return Objects.equals(elasticGpuSet(), other.elasticGpuSet()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (elasticGpuSet() != null) {
            sb.append("ElasticGpuSet: ").append(elasticGpuSet()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuSet":
            return Optional.of(clazz.cast(elasticGpuSet()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeElasticGpusResponse> {
        /**
         * <p>
         * Information about the Elastic GPUs.
         * </p>
         * 
         * @param elasticGpuSet
         *        Information about the Elastic GPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet);

        /**
         * <p>
         * Information about the Elastic GPUs.
         * </p>
         * 
         * @param elasticGpuSet
         *        Information about the Elastic GPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSet(ElasticGpus... elasticGpuSet);

        /**
         * <p>
         * The total number of items to return. If the total number of items available is more than the value specified
         * in max-items then a Next-Token will be provided in the output that you can use to resume pagination.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return. If the total number of items available is more than the value
         *        specified in max-items then a Next-Token will be provided in the output that you can use to resume
         *        pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ElasticGpus> elasticGpuSet;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusResponse model) {
            elasticGpuSet(model.elasticGpuSet);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<ElasticGpus.Builder> getElasticGpuSet() {
            return elasticGpuSet != null ? elasticGpuSet.stream().map(ElasticGpus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copy(elasticGpuSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSet(ElasticGpus... elasticGpuSet) {
            elasticGpuSet(Arrays.asList(elasticGpuSet));
            return this;
        }

        public final void setElasticGpuSet(Collection<ElasticGpus.BuilderImpl> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copyFromBuilder(elasticGpuSet);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeElasticGpusResponse build() {
            return new DescribeElasticGpusResponse(this);
        }
    }
}
