/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationOfferingsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeHostReservationOfferingsResponse.Builder, DescribeHostReservationOfferingsResponse> {
    private final String nextToken;

    private final List<HostOffering> offeringSet;

    private DescribeHostReservationOfferingsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.offeringSet = builder.offeringSet;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the offerings.
     */
    public List<HostOffering> offeringSet() {
        return offeringSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(offeringSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsResponse)) {
            return false;
        }
        DescribeHostReservationOfferingsResponse other = (DescribeHostReservationOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(offeringSet(), other.offeringSet());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (offeringSet() != null) {
            sb.append("OfferingSet: ").append(offeringSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "OfferingSet":
            return Optional.of(clazz.cast(offeringSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the offerings.
         * </p>
         * 
         * @param offeringSet
         *        Information about the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringSet(Collection<HostOffering> offeringSet);

        /**
         * <p>
         * Information about the offerings.
         * </p>
         * 
         * @param offeringSet
         *        Information about the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringSet(HostOffering... offeringSet);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<HostOffering> offeringSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsResponse model) {
            nextToken(model.nextToken);
            offeringSet(model.offeringSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<HostOffering.Builder> getOfferingSet() {
            return offeringSet != null ? offeringSet.stream().map(HostOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(HostOffering... offeringSet) {
            offeringSet(Arrays.asList(offeringSet));
            return this;
        }

        public final void setOfferingSet(Collection<HostOffering.BuilderImpl> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copyFromBuilder(offeringSet);
        }

        @Override
        public DescribeHostReservationOfferingsResponse build() {
            return new DescribeHostReservationOfferingsResponse(this);
        }
    }
}
