/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeMovingAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMovingAddressesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMovingAddressesResponse.Builder, DescribeMovingAddressesResponse> {
    private final List<MovingAddressStatus> movingAddressStatuses;

    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The status for each Elastic IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The status for each Elastic IP address.
     */
    public List<MovingAddressStatus> movingAddressStatuses() {
        return movingAddressStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(movingAddressStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse) obj;
        return Objects.equals(movingAddressStatuses(), other.movingAddressStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (movingAddressStatuses() != null) {
            sb.append("MovingAddressStatuses: ").append(movingAddressStatuses()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MovingAddressStatuses":
            return Optional.of(clazz.cast(movingAddressStatuses()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses);

        /**
         * <p>
         * The status for each Elastic IP address.
         * </p>
         * 
         * @param movingAddressStatuses
         *        The status for each Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            movingAddressStatuses(model.movingAddressStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus.Builder> getMovingAddressStatuses() {
            return movingAddressStatuses != null ? movingAddressStatuses.stream().map(MovingAddressStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus... movingAddressStatuses) {
            movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus.BuilderImpl> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copyFromBuilder(movingAddressStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }
    }
}
