/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribePlacementGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePlacementGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribePlacementGroupsRequest.Builder, DescribePlacementGroupsRequest> {
    private final List<Filter> filters;

    private final List<String> groupNames;

    private DescribePlacementGroupsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupNames = builder.groupNames;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the placement group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the placement group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more placement group names.
     * </p>
     * <p>
     * Default: Describes all your placement groups, or only those otherwise specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more placement group names.</p>
     *         <p>
     *         Default: Describes all your placement groups, or only those otherwise specified.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsRequest)) {
            return false;
        }
        DescribePlacementGroupsRequest other = (DescribePlacementGroupsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(groupNames(), other.groupNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "GroupNames":
            return Optional.of(clazz.cast(groupNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePlacementGroupsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the placement group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the placement group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the placement group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the placement group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more placement group names.
         * </p>
         * <p>
         * Default: Describes all your placement groups, or only those otherwise specified.
         * </p>
         * 
         * @param groupNames
         *        One or more placement group names.</p>
         *        <p>
         *        Default: Describes all your placement groups, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more placement group names.
         * </p>
         * <p>
         * Default: Describes all your placement groups, or only those otherwise specified.
         * </p>
         * 
         * @param groupNames
         *        One or more placement group names.</p>
         *        <p>
         *        Default: Describes all your placement groups, or only those otherwise specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);
    }

    static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsRequest model) {
            filters(model.filters);
            groupNames(model.groupNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
        }

        @Override
        public DescribePlacementGroupsRequest build() {
            return new DescribePlacementGroupsRequest(this);
        }
    }
}
