/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcEndpointsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVpcEndpointsRequest.Builder, DescribeVpcEndpointsRequest> {
    private final List<String> vpcEndpointIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeVpcEndpointsRequest(BuilderImpl builder) {
        this.vpcEndpointIds = builder.vpcEndpointIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more endpoint IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more endpoint IDs.
     */
    public List<String> vpcEndpointIds() {
        return vpcEndpointIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>service-name</code>: The name of the AWS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-endpoint-id</code>: The ID of the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>service-name</code>: The name of the AWS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-endpoint-id</code>: The ID of the endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> |
     *         <code>available</code> | <code>deleting</code> | <code>deleted</code>)
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. The request returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * <p>
     * Constraint: If the value is greater than 1000, we return only 1000 items.
     * </p>
     * 
     * @return The maximum number of items to return for this request. The request returns a token that you can specify
     *         in a subsequent call to get the next set of results.</p>
     *         <p>
     *         Constraint: If the value is greater than 1000, we return only 1000 items.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a prior call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a prior call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsRequest)) {
            return false;
        }
        DescribeVpcEndpointsRequest other = (DescribeVpcEndpointsRequest) obj;
        return Objects.equals(vpcEndpointIds(), other.vpcEndpointIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcEndpointIds() != null) {
            sb.append("VpcEndpointIds: ").append(vpcEndpointIds()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointIds":
            return Optional.of(clazz.cast(vpcEndpointIds()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcEndpointsRequest> {
        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(Collection<String> vpcEndpointIds);

        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(String... vpcEndpointIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>service-name</code>: The name of the AWS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-endpoint-id</code>: The ID of the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>service-name</code>: The name of the AWS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-endpoint-id</code>: The ID of the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> |
         *        <code>available</code> | <code>deleting</code> | <code>deleted</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>service-name</code>: The name of the AWS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-endpoint-id</code>: The ID of the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>service-name</code>: The name of the AWS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-endpoint-id</code>: The ID of the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> |
         *        <code>available</code> | <code>deleting</code> | <code>deleted</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of items to return for this request. The request returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * <p>
         * Constraint: If the value is greater than 1000, we return only 1000 items.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. The request returns a token that you can
         *        specify in a subsequent call to get the next set of results.</p>
         *        <p>
         *        Constraint: If the value is greater than 1000, we return only 1000 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a prior call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a prior call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> vpcEndpointIds;

        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsRequest model) {
            vpcEndpointIds(model.vpcEndpointIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getVpcEndpointIds() {
            return vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String... vpcEndpointIds) {
            vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointsRequest build() {
            return new DescribeVpcEndpointsRequest(this);
        }
    }
}
