/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DetachClassicLinkVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachClassicLinkVpcRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachClassicLinkVpcRequest.Builder, DetachClassicLinkVpcRequest> {
    private final String instanceId;

    private final String vpcId;

    private DetachClassicLinkVpcRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ID of the instance to unlink from the VPC.
     * </p>
     * 
     * @return The ID of the instance to unlink from the VPC.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the VPC to which the instance is linked.
     * </p>
     * 
     * @return The ID of the VPC to which the instance is linked.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachClassicLinkVpcRequest)) {
            return false;
        }
        DetachClassicLinkVpcRequest other = (DetachClassicLinkVpcRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetachClassicLinkVpcRequest> {
        /**
         * <p>
         * The ID of the instance to unlink from the VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to unlink from the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the VPC to which the instance is linked.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC to which the instance is linked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachClassicLinkVpcRequest model) {
            instanceId(model.instanceId);
            vpcId(model.vpcId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public DetachClassicLinkVpcRequest build() {
            return new DetachClassicLinkVpcRequest(this);
        }
    }
}
