/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a DNS entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DnsEntry implements ToCopyableBuilder<DnsEntry.Builder, DnsEntry> {
    private final String dnsName;

    private final String hostedZoneId;

    private DnsEntry(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * The DNS name.
     * </p>
     * 
     * @return The DNS name.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID of the private hosted zone.
     * </p>
     * 
     * @return The ID of the private hosted zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsEntry)) {
            return false;
        }
        DnsEntry other = (DnsEntry) obj;
        return Objects.equals(dnsName(), other.dnsName()) && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dnsName() != null) {
            sb.append("DnsName: ").append(dnsName()).append(",");
        }
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsName":
            return Optional.of(clazz.cast(dnsName()));
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DnsEntry> {
        /**
         * <p>
         * The DNS name.
         * </p>
         * 
         * @param dnsName
         *        The DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID of the private hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String dnsName;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsEntry model) {
            dnsName(model.dnsName);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public DnsEntry build() {
            return new DnsEntry(this);
        }
    }
}
