/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an egress-only Internet gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EgressOnlyInternetGateway implements ToCopyableBuilder<EgressOnlyInternetGateway.Builder, EgressOnlyInternetGateway> {
    private final List<InternetGatewayAttachment> attachments;

    private final String egressOnlyInternetGatewayId;

    private EgressOnlyInternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * Information about the attachment of the egress-only Internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the attachment of the egress-only Internet gateway.
     */
    public List<InternetGatewayAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The ID of the egress-only Internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressOnlyInternetGateway)) {
            return false;
        }
        EgressOnlyInternetGateway other = (EgressOnlyInternetGateway) obj;
        return Objects.equals(attachments(), other.attachments())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachments() != null) {
            sb.append("Attachments: ").append(attachments()).append(",");
        }
        if (egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(egressOnlyInternetGatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachments":
            return Optional.of(clazz.cast(attachments()));
        case "EgressOnlyInternetGatewayId":
            return Optional.of(clazz.cast(egressOnlyInternetGatewayId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, EgressOnlyInternetGateway> {
        /**
         * <p>
         * Information about the attachment of the egress-only Internet gateway.
         * </p>
         * 
         * @param attachments
         *        Information about the attachment of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<InternetGatewayAttachment> attachments);

        /**
         * <p>
         * Information about the attachment of the egress-only Internet gateway.
         * </p>
         * 
         * @param attachments
         *        Information about the attachment of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(InternetGatewayAttachment... attachments);

        /**
         * <p>
         * The ID of the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private List<InternetGatewayAttachment> attachments;

        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressOnlyInternetGateway model) {
            attachments(model.attachments);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final Collection<InternetGatewayAttachment.Builder> getAttachments() {
            return attachments != null ? attachments.stream().map(InternetGatewayAttachment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public EgressOnlyInternetGateway build() {
            return new EgressOnlyInternetGateway(this);
        }
    }
}
