/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportSnapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportSnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ImportSnapshotRequest.Builder, ImportSnapshotRequest> {
    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final SnapshotDiskContainer diskContainer;

    private final String roleName;

    private ImportSnapshotRequest(BuilderImpl builder) {
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * Token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return Token to enable idempotency for VM import requests.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description string for the import snapshot task.
     * </p>
     * 
     * @return The description string for the import snapshot task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk container.
     * </p>
     * 
     * @return Information about the disk container.
     */
    public SnapshotDiskContainer diskContainer() {
        return diskContainer;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientData());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskContainer());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest) obj;
        return Objects.equals(clientData(), other.clientData()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description()) && Objects.equals(diskContainer(), other.diskContainer())
                && Objects.equals(roleName(), other.roleName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientData() != null) {
            sb.append("ClientData: ").append(clientData()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (diskContainer() != null) {
            sb.append("DiskContainer: ").append(diskContainer()).append(",");
        }
        if (roleName() != null) {
            sb.append("RoleName: ").append(roleName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientData":
            return Optional.of(clazz.cast(clientData()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DiskContainer":
            return Optional.of(clazz.cast(diskContainer()));
        case "RoleName":
            return Optional.of(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportSnapshotRequest> {
        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientData.Builder} avoiding the need to create
         * one manually via {@link ClientData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientData.Builder#build()} is called immediately and its result
         * is passed to {@link #clientData(ClientData)}.
         * 
         * @param clientData
         *        a consumer that will call methods on {@link ClientData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientData(ClientData)
         */
        default Builder clientData(Consumer<ClientData.Builder> clientData) {
            return clientData(ClientData.builder().apply(clientData).build());
        }

        /**
         * <p>
         * Token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        Token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description string for the import snapshot task.
         * </p>
         * 
         * @param description
         *        The description string for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * 
         * @param diskContainer
         *        Information about the disk container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainer(SnapshotDiskContainer diskContainer);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotDiskContainer.Builder} avoiding the need
         * to create one manually via {@link SnapshotDiskContainer#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotDiskContainer.Builder#build()} is called immediately and
         * its result is passed to {@link #diskContainer(SnapshotDiskContainer)}.
         * 
         * @param diskContainer
         *        a consumer that will call methods on {@link SnapshotDiskContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskContainer(SnapshotDiskContainer)
         */
        default Builder diskContainer(Consumer<SnapshotDiskContainer.Builder> diskContainer) {
            return diskContainer(SnapshotDiskContainer.builder().apply(diskContainer).build());
        }

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);
    }

    static final class BuilderImpl implements Builder {
        private ClientData clientData;

        private String clientToken;

        private String description;

        private SnapshotDiskContainer diskContainer;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            clientData(model.clientData);
            clientToken(model.clientToken);
            description(model.description);
            diskContainer(model.diskContainer);
            roleName(model.roleName);
        }

        public final ClientData.Builder getClientData() {
            return clientData != null ? clientData.toBuilder() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SnapshotDiskContainer.Builder getDiskContainer() {
            return diskContainer != null ? diskContainer.toBuilder() : null;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final void setDiskContainer(SnapshotDiskContainer.BuilderImpl diskContainer) {
            this.diskContainer = diskContainer != null ? diskContainer.build() : null;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }
    }
}
