/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceBlockDeviceMappingSpecification implements
        ToCopyableBuilder<InstanceBlockDeviceMappingSpecification.Builder, InstanceBlockDeviceMappingSpecification> {
    private final String deviceName;

    private final EbsInstanceBlockDeviceSpecification ebs;

    private final String noDevice;

    private final String virtualName;

    private InstanceBlockDeviceMappingSpecification(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public EbsInstanceBlockDeviceSpecification ebs() {
        return ebs;
    }

    /**
     * <p>
     * suppress the specified device included in the block device mapping.
     * </p>
     * 
     * @return suppress the specified device included in the block device mapping.
     */
    public String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name.
     * </p>
     * 
     * @return The virtual device name.
     */
    public String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMappingSpecification)) {
            return false;
        }
        InstanceBlockDeviceMappingSpecification other = (InstanceBlockDeviceMappingSpecification) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(noDevice(), other.noDevice()) && Objects.equals(virtualName(), other.virtualName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        if (noDevice() != null) {
            sb.append("NoDevice: ").append(noDevice()).append(",");
        }
        if (virtualName() != null) {
            sb.append("VirtualName: ").append(virtualName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.of(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.of(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.of(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceBlockDeviceMappingSpecification> {
        /**
         * <p>
         * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsInstanceBlockDeviceSpecification ebs);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsInstanceBlockDeviceSpecification.Builder}
         * avoiding the need to create one manually via {@link EbsInstanceBlockDeviceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsInstanceBlockDeviceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #ebs(EbsInstanceBlockDeviceSpecification)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsInstanceBlockDeviceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsInstanceBlockDeviceSpecification)
         */
        default Builder ebs(Consumer<EbsInstanceBlockDeviceSpecification.Builder> ebs) {
            return ebs(EbsInstanceBlockDeviceSpecification.builder().apply(ebs).build());
        }

        /**
         * <p>
         * suppress the specified device included in the block device mapping.
         * </p>
         * 
         * @param noDevice
         *        suppress the specified device included in the block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsInstanceBlockDeviceSpecification ebs;

        private String noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMappingSpecification model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDeviceSpecification.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDeviceSpecification ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDeviceSpecification.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public InstanceBlockDeviceMappingSpecification build() {
            return new InstanceBlockDeviceMappingSpecification(this);
        }
    }
}
