/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of permissions for a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IpPermission implements ToCopyableBuilder<IpPermission.Builder, IpPermission> {
    private final Integer fromPort;

    private final String ipProtocol;

    private final List<Ipv6Range> ipv6Ranges;

    private final List<PrefixListId> prefixListIds;

    private final Integer toPort;

    private final List<UserIdGroupPair> userIdGroupPairs;

    private final List<IpRange> ipv4Ranges;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipv4Ranges = builder.ipv4Ranges;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code>
     * indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
     *         <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify
     *         all codes.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     * </p>
     * <p>
     * [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying
     * <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or
     * <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range you specify. For
     * <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>58</code>
     * (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and codes is allowed when
     * authorizing rules.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     *         </p>
     *         <p>
     *         [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
     *         specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
     *         <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range
     *         you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port
     *         range. For <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't, traffic for
     *         all types and codes is allowed when authorizing rules.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * [EC2-VPC only] One or more IPv6 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC only] One or more IPv6 ranges.
     */
    public List<Ipv6Range> ipv6Ranges() {
        return ipv6Ranges;
    }

    /**
     * <p>
     * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
     * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
     * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
     * endpoint from instances associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
     *         <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
     *         <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
     *         VPC endpoint from instances associated with the security group.
     */
    public List<PrefixListId> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates
     * all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all ICMP/ICMPv6 types, you must specify all
     * codes.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
     *         indicates all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all ICMP/ICMPv6 types, you
     *         must specify all codes.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * One or more security group and AWS account ID pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group and AWS account ID pairs.
     */
    public List<UserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    /**
     * <p>
     * One or more IPv4 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IPv4 ranges.
     */
    public List<IpRange> ipv4Ranges() {
        return ipv4Ranges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Ranges());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListIds());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(userIdGroupPairs());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4Ranges());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(ipProtocol(), other.ipProtocol())
                && Objects.equals(ipv6Ranges(), other.ipv6Ranges()) && Objects.equals(prefixListIds(), other.prefixListIds())
                && Objects.equals(toPort(), other.toPort()) && Objects.equals(userIdGroupPairs(), other.userIdGroupPairs())
                && Objects.equals(ipv4Ranges(), other.ipv4Ranges());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (ipProtocol() != null) {
            sb.append("IpProtocol: ").append(ipProtocol()).append(",");
        }
        if (ipv6Ranges() != null) {
            sb.append("Ipv6Ranges: ").append(ipv6Ranges()).append(",");
        }
        if (prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(prefixListIds()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (userIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: ").append(userIdGroupPairs()).append(",");
        }
        if (ipv4Ranges() != null) {
            sb.append("Ipv4Ranges: ").append(ipv4Ranges()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.of(clazz.cast(ipProtocol()));
        case "Ipv6Ranges":
            return Optional.of(clazz.cast(ipv6Ranges()));
        case "PrefixListIds":
            return Optional.of(clazz.cast(prefixListIds()));
        case "ToPort":
            return Optional.of(clazz.cast(toPort()));
        case "UserIdGroupPairs":
            return Optional.of(clazz.cast(userIdGroupPairs()));
        case "Ipv4Ranges":
            return Optional.of(clazz.cast(ipv4Ranges()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IpPermission> {
        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         * <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all
         * codes.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
         *        specify all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         * </p>
         * <p>
         * [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
         * specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
         * <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port range you
         * specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For
         * <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't, traffic for all types and
         * codes is allowed when authorizing rules.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         *        </p>
         *        <p>
         *        [EC2-VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
         *        specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
         *        <code>icmp</code>, or <code>58</code> (ICMPv6) allows traffic on all ports, regardless of any port
         *        range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a
         *        port range. For <code>58</code> (ICMPv6), you can optionally specify a port range; if you don't,
         *        traffic for all types and codes is allowed when authorizing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * [EC2-VPC only] One or more IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [EC2-VPC only] One or more IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges);

        /**
         * <p>
         * [EC2-VPC only] One or more IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [EC2-VPC only] One or more IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Ipv6Range... ipv6Ranges);

        /**
         * <p>
         * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
         * endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         *        <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         *        <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
         *        VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<PrefixListId> prefixListIds);

        /**
         * <p>
         * (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         * <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         * <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC
         * endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        (Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and
         *        <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an
         *        <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a
         *        VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(PrefixListId... prefixListIds);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
         * indicates all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all ICMP/ICMPv6 types, you must
         * specify all codes.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 codes for the specified ICMP type. If you specify all
         *        ICMP/ICMPv6 types, you must specify all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * One or more security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * One or more security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs);

        /**
         * <p>
         * One or more IPv4 ranges.
         * </p>
         * 
         * @param ipv4Ranges
         *        One or more IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Ranges(Collection<IpRange> ipv4Ranges);

        /**
         * <p>
         * One or more IPv4 ranges.
         * </p>
         * 
         * @param ipv4Ranges
         *        One or more IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Ranges(IpRange... ipv4Ranges);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private String ipProtocol;

        private List<Ipv6Range> ipv6Ranges;

        private List<PrefixListId> prefixListIds;

        private Integer toPort;

        private List<UserIdGroupPair> userIdGroupPairs;

        private List<IpRange> ipv4Ranges;

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            ipv6Ranges(model.ipv6Ranges);
            prefixListIds(model.prefixListIds);
            toPort(model.toPort);
            userIdGroupPairs(model.userIdGroupPairs);
            ipv4Ranges(model.ipv4Ranges);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<Ipv6Range.Builder> getIpv6Ranges() {
            return ipv6Ranges != null ? ipv6Ranges.stream().map(Ipv6Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range... ipv6Ranges) {
            ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final Collection<PrefixListId.Builder> getPrefixListIds() {
            return prefixListIds != null ? prefixListIds.stream().map(PrefixListId::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            return userIdGroupPairs != null ? userIdGroupPairs.stream().map(UserIdGroupPair::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        public final Collection<IpRange.Builder> getIpv4Ranges() {
            return ipv4Ranges != null ? ipv4Ranges.stream().map(IpRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Ranges(IpRange... ipv4Ranges) {
            ipv4Ranges(Arrays.asList(ipv4Ranges));
            return this;
        }

        public final void setIpv4Ranges(Collection<IpRange.BuilderImpl> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copyFromBuilder(ipv4Ranges);
        }

        @Override
        public IpPermission build() {
            return new IpPermission(this);
        }
    }
}
