/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVpcTenancy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcTenancyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyVpcTenancyRequest.Builder, ModifyVpcTenancyRequest> {
    private final String vpcId;

    private final String instanceTenancy;

    private ModifyVpcTenancyRequest(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The instance tenancy attribute for the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link VpcTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The instance tenancy attribute for the VPC.
     * @see VpcTenancy
     */
    public VpcTenancy instanceTenancy() {
        return VpcTenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The instance tenancy attribute for the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link VpcTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The instance tenancy attribute for the VPC.
     * @see VpcTenancy
     */
    public String instanceTenancyString() {
        return instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcTenancyRequest)) {
            return false;
        }
        ModifyVpcTenancyRequest other = (ModifyVpcTenancyRequest) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(instanceTenancyString(), other.instanceTenancyString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "InstanceTenancy":
            return Optional.of(clazz.cast(instanceTenancyString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVpcTenancyRequest> {
        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The instance tenancy attribute for the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The instance tenancy attribute for the VPC.
         * @see VpcTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcTenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The instance tenancy attribute for the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The instance tenancy attribute for the VPC.
         * @see VpcTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcTenancy
         */
        Builder instanceTenancy(VpcTenancy instanceTenancy);
    }

    static final class BuilderImpl implements Builder {
        private String vpcId;

        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcTenancyRequest model) {
            vpcId(model.vpcId);
            instanceTenancy(model.instanceTenancy);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(VpcTenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public ModifyVpcTenancyRequest build() {
            return new ModifyVpcTenancyRequest(this);
        }
    }
}
