/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfaceAttachment implements
        ToCopyableBuilder<NetworkInterfaceAttachment.Builder, NetworkInterfaceAttachment> {
    private final Instant attachTime;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private final Integer deviceIndex;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String status;

    private NetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp indicating when the attachment initiated.
     * </p>
     * 
     * @return The timestamp indicating when the attachment initiated.
     */
    public Instant attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The device index of the network interface attachment on the instance.
     * </p>
     * 
     * @return The device index of the network interface attachment on the instance.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the instance.
     * </p>
     * 
     * @return The AWS account ID of the owner of the instance.
     */
    public String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The attachment state.
     * @see AttachmentStatus
     */
    public AttachmentStatus status() {
        return AttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The attachment state.
     * @see AttachmentStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachment)) {
            return false;
        }
        NetworkInterfaceAttachment other = (NetworkInterfaceAttachment) obj;
        return Objects.equals(attachTime(), other.attachTime()) && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(deviceIndex(), other.deviceIndex()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId())
                && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachTime() != null) {
            sb.append("AttachTime: ").append(attachTime()).append(",");
        }
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(deviceIndex()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceOwnerId() != null) {
            sb.append("InstanceOwnerId: ").append(instanceOwnerId()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.of(clazz.cast(attachTime()));
        case "AttachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.of(clazz.cast(deleteOnTermination()));
        case "DeviceIndex":
            return Optional.of(clazz.cast(deviceIndex()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.of(clazz.cast(instanceOwnerId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfaceAttachment> {
        /**
         * <p>
         * The timestamp indicating when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The timestamp indicating when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);

        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The device index of the network interface attachment on the instance.
         * </p>
         * 
         * @param deviceIndex
         *        The device index of the network interface attachment on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The AWS account ID of the owner of the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The AWS account ID of the owner of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant attachTime;

        private String attachmentId;

        private Boolean deleteOnTermination;

        private Integer deviceIndex;

        private String instanceId;

        private String instanceOwnerId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachment model) {
            attachTime(model.attachTime);
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
            deviceIndex(model.deviceIndex);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            status(model.status);
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public NetworkInterfaceAttachment build() {
            return new NetworkInterfaceAttachment(this);
        }
    }
}
