/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual private gateway propagating route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PropagatingVgw implements ToCopyableBuilder<PropagatingVgw.Builder, PropagatingVgw> {
    private final String gatewayId;

    private PropagatingVgw(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway (VGW).
     * </p>
     * 
     * @return The ID of the virtual private gateway (VGW).
     */
    public String gatewayId() {
        return gatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropagatingVgw)) {
            return false;
        }
        PropagatingVgw other = (PropagatingVgw) obj;
        return Objects.equals(gatewayId(), other.gatewayId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (gatewayId() != null) {
            sb.append("GatewayId: ").append(gatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.of(clazz.cast(gatewayId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PropagatingVgw> {
        /**
         * <p>
         * The ID of the virtual private gateway (VGW).
         * </p>
         * 
         * @param gatewayId
         *        The ID of the virtual private gateway (VGW).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(PropagatingVgw model) {
            gatewayId(model.gatewayId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public PropagatingVgw build() {
            return new PropagatingVgw(this);
        }
    }
}
