/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReleaseAddress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReleaseAddressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReleaseAddressRequest.Builder, ReleaseAddressRequest> {
    private final String allocationId;

    private final String publicIp;

    private ReleaseAddressRequest(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] The allocation ID. Required for EC2-VPC.
     * </p>
     * 
     * @return [EC2-VPC] The allocation ID. Required for EC2-VPC.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
     * </p>
     * 
     * @return [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseAddressRequest)) {
            return false;
        }
        ReleaseAddressRequest other = (ReleaseAddressRequest) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(publicIp(), other.publicIp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (allocationId() != null) {
            sb.append("AllocationId: ").append(allocationId()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.of(clazz.cast(allocationId()));
        case "PublicIp":
            return Optional.of(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReleaseAddressRequest> {
        /**
         * <p>
         * [EC2-VPC] The allocation ID. Required for EC2-VPC.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The allocation ID. Required for EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
         * </p>
         * 
         * @param publicIp
         *        [EC2-Classic] The Elastic IP address. Required for EC2-Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String allocationId;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseAddressRequest model) {
            allocationId(model.allocationId);
            publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public ReleaseAddressRequest build() {
            return new ReleaseAddressRequest(this);
        }
    }
}
