/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the Reservation object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class RunInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RunInstancesResponse.Builder, RunInstancesResponse> {
    private final Reservation reservation;

    private RunInstancesResponse(BuilderImpl builder) {
        this.reservation = builder.reservation;
    }

    /**
     * <p>
     * Describes a reservation.
     * </p>
     * 
     * @return Describes a reservation.
     */
    public Reservation reservation() {
        return reservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesResponse)) {
            return false;
        }
        RunInstancesResponse other = (RunInstancesResponse) obj;
        return Objects.equals(reservation(), other.reservation());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (reservation() != null) {
            sb.append("Reservation: ").append(reservation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reservation":
            return Optional.of(clazz.cast(reservation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RunInstancesResponse> {
        /**
         * <p>
         * Describes a reservation.
         * </p>
         * 
         * @param reservation
         *        Describes a reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservation(Reservation reservation);

        /**
         * <p>
         * Describes a reservation.
         * </p>
         * This is a convenience that creates an instance of the {@link Reservation.Builder} avoiding the need to create
         * one manually via {@link Reservation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Reservation.Builder#build()} is called immediately and its result
         * is passed to {@link #reservation(Reservation)}.
         * 
         * @param reservation
         *        a consumer that will call methods on {@link Reservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservation(Reservation)
         */
        default Builder reservation(Consumer<Reservation.Builder> reservation) {
            return reservation(Reservation.builder().apply(reservation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Reservation reservation;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesResponse model) {
            reservation(model.reservation);
        }

        public final Reservation.Builder getReservation() {
            return reservation != null ? reservation.toBuilder() : null;
        }

        @Override
        public final Builder reservation(Reservation reservation) {
            this.reservation = reservation;
            return this;
        }

        public final void setReservation(Reservation.BuilderImpl reservation) {
            this.reservation = reservation != null ? reservation.build() : null;
        }

        @Override
        public RunInstancesResponse build() {
            return new RunInstancesResponse(this);
        }
    }
}
