/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SecurityGroupIdentifier implements ToCopyableBuilder<SecurityGroupIdentifier.Builder, SecurityGroupIdentifier> {
    private final String groupId;

    private final String groupName;

    private SecurityGroupIdentifier(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupIdentifier)) {
            return false;
        }
        SecurityGroupIdentifier other = (SecurityGroupIdentifier) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityGroupIdentifier> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupIdentifier model) {
            groupId(model.groupId);
            groupName(model.groupName);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public SecurityGroupIdentifier build() {
            return new SecurityGroupIdentifier(this);
        }
    }
}
