/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ServiceDetail implements ToCopyableBuilder<ServiceDetail.Builder, ServiceDetail> {
    private final String serviceName;

    private final List<ServiceTypeDetail> serviceType;

    private final List<String> availabilityZones;

    private final String owner;

    private final List<String> baseEndpointDnsNames;

    private final String privateDnsName;

    private final Boolean vpcEndpointPolicySupported;

    private final Boolean acceptanceRequired;

    private ServiceDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.availabilityZones = builder.availabilityZones;
        this.owner = builder.owner;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.vpcEndpointPolicySupported = builder.vpcEndpointPolicySupported;
        this.acceptanceRequired = builder.acceptanceRequired;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The type of service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The type of service.
     */
    public List<ServiceTypeDetail> serviceType() {
        return serviceType;
    }

    /**
     * <p>
     * The Availability Zones in which the service is available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Availability Zones in which the service is available.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The AWS account ID of the service owner.
     * </p>
     * 
     * @return The AWS account ID of the service owner.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * The DNS names for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The DNS names for the service.
     */
    public List<String> baseEndpointDnsNames() {
        return baseEndpointDnsNames;
    }

    /**
     * <p>
     * The private DNS name for the service.
     * </p>
     * 
     * @return The private DNS name for the service.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * Indicates whether the service supports endpoint policies.
     * </p>
     * 
     * @return Indicates whether the service supports endpoint policies.
     */
    public Boolean vpcEndpointPolicySupported() {
        return vpcEndpointPolicySupported;
    }

    /**
     * <p>
     * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
     * </p>
     * 
     * @return Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
     */
    public Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(baseEndpointDnsNames());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointPolicySupported());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceType(), other.serviceType())
                && Objects.equals(availabilityZones(), other.availabilityZones()) && Objects.equals(owner(), other.owner())
                && Objects.equals(baseEndpointDnsNames(), other.baseEndpointDnsNames())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(vpcEndpointPolicySupported(), other.vpcEndpointPolicySupported())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (serviceName() != null) {
            sb.append("ServiceName: ").append(serviceName()).append(",");
        }
        if (serviceType() != null) {
            sb.append("ServiceType: ").append(serviceType()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (baseEndpointDnsNames() != null) {
            sb.append("BaseEndpointDnsNames: ").append(baseEndpointDnsNames()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (vpcEndpointPolicySupported() != null) {
            sb.append("VpcEndpointPolicySupported: ").append(vpcEndpointPolicySupported()).append(",");
        }
        if (acceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(acceptanceRequired()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.of(clazz.cast(serviceName()));
        case "ServiceType":
            return Optional.of(clazz.cast(serviceType()));
        case "AvailabilityZones":
            return Optional.of(clazz.cast(availabilityZones()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        case "BaseEndpointDnsNames":
            return Optional.of(clazz.cast(baseEndpointDnsNames()));
        case "PrivateDnsName":
            return Optional.of(clazz.cast(privateDnsName()));
        case "VpcEndpointPolicySupported":
            return Optional.of(clazz.cast(vpcEndpointPolicySupported()));
        case "AcceptanceRequired":
            return Optional.of(clazz.cast(acceptanceRequired()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceName
         *        The Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(Collection<ServiceTypeDetail> serviceType);

        /**
         * <p>
         * The type of service.
         * </p>
         * 
         * @param serviceType
         *        The type of service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceType(ServiceTypeDetail... serviceType);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones in which the service is available.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones in which the service is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The AWS account ID of the service owner.
         * </p>
         * 
         * @param owner
         *        The AWS account ID of the service owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames);

        /**
         * <p>
         * The DNS names for the service.
         * </p>
         * 
         * @param baseEndpointDnsNames
         *        The DNS names for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpointDnsNames(String... baseEndpointDnsNames);

        /**
         * <p>
         * The private DNS name for the service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * Indicates whether the service supports endpoint policies.
         * </p>
         * 
         * @param vpcEndpointPolicySupported
         *        Indicates whether the service supports endpoint policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported);

        /**
         * <p>
         * Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether VPC endpoint connection requests to the service must be accepted by the service
         *        owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private List<ServiceTypeDetail> serviceType;

        private List<String> availabilityZones;

        private String owner;

        private List<String> baseEndpointDnsNames;

        private String privateDnsName;

        private Boolean vpcEndpointPolicySupported;

        private Boolean acceptanceRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDetail model) {
            serviceName(model.serviceName);
            serviceType(model.serviceType);
            availabilityZones(model.availabilityZones);
            owner(model.owner);
            baseEndpointDnsNames(model.baseEndpointDnsNames);
            privateDnsName(model.privateDnsName);
            vpcEndpointPolicySupported(model.vpcEndpointPolicySupported);
            acceptanceRequired(model.acceptanceRequired);
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Collection<ServiceTypeDetail.Builder> getServiceType() {
            return serviceType != null ? serviceType.stream().map(ServiceTypeDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail... serviceType) {
            serviceType(Arrays.asList(serviceType));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            return baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String... baseEndpointDnsNames) {
            baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Boolean getVpcEndpointPolicySupported() {
            return vpcEndpointPolicySupported;
        }

        @Override
        public final Builder vpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
            return this;
        }

        public final void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
            this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        public ServiceDetail build() {
            return new ServiceDetail(this);
        }
    }
}
