/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage location for an instance store-backed AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Storage implements ToCopyableBuilder<Storage.Builder, Storage> {
    private final S3Storage s3;

    private Storage(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * An Amazon S3 storage location.
     * </p>
     * 
     * @return An Amazon S3 storage location.
     */
    public S3Storage s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Storage)) {
            return false;
        }
        Storage other = (Storage) obj;
        return Objects.equals(s3(), other.s3());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (s3() != null) {
            sb.append("S3: ").append(s3()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.of(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Storage> {
        /**
         * <p>
         * An Amazon S3 storage location.
         * </p>
         * 
         * @param s3
         *        An Amazon S3 storage location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Storage s3);

        /**
         * <p>
         * An Amazon S3 storage location.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Storage.Builder} avoiding the need to create
         * one manually via {@link S3Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Storage.Builder#build()} is called immediately and its result
         * is passed to {@link #s3(S3Storage)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Storage)
         */
        default Builder s3(Consumer<S3Storage.Builder> s3) {
            return s3(S3Storage.builder().apply(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Storage s3;

        private BuilderImpl() {
        }

        private BuilderImpl(Storage model) {
            s3(model.s3);
        }

        public final S3Storage.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Storage s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Storage.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public Storage build() {
            return new Storage(this);
        }
    }
}
