/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Convertible Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetConfiguration implements ToCopyableBuilder<TargetConfiguration.Builder, TargetConfiguration> {
    private final Integer instanceCount;

    private final String offeringId;

    private TargetConfiguration(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is reserved
     * and cannot be specified in a request
     * </p>
     * 
     * @return The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is
     *         reserved and cannot be specified in a request
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The ID of the Convertible Reserved Instance offering.
     * </p>
     * 
     * @return The ID of the Convertible Reserved Instance offering.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfiguration)) {
            return false;
        }
        TargetConfiguration other = (TargetConfiguration) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(offeringId(), other.offeringId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TargetConfiguration> {
        /**
         * <p>
         * The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is
         * reserved and cannot be specified in a request
         * </p>
         * 
         * @param instanceCount
         *        The number of instances the Convertible Reserved Instance offering can be applied to. This parameter
         *        is reserved and cannot be specified in a request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The ID of the Convertible Reserved Instance offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the Convertible Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfiguration model) {
            instanceCount(model.instanceCount);
            offeringId(model.offeringId);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public TargetConfiguration build() {
            return new TargetConfiguration(this);
        }
    }
}
