/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the user data for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UserData implements ToCopyableBuilder<UserData.Builder, UserData> {
    private final String data;

    private UserData(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * <p>
     * The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you
     * can load the text from a file. Otherwise, you must provide Base64-encoded text.
     * </p>
     * 
     * @return The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you,
     *         and you can load the text from a file. Otherwise, you must provide Base64-encoded text.
     */
    public String data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData) obj;
        return Objects.equals(data(), other.data());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (data() != null) {
            sb.append("Data: ").append(data()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.of(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UserData> {
        /**
         * <p>
         * The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and
         * you can load the text from a file. Otherwise, you must provide Base64-encoded text.
         * </p>
         * 
         * @param data
         *        The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you,
         *        and you can load the text from a file. Otherwise, you must provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);
    }

    static final class BuilderImpl implements Builder {
        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            data(model.data);
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public UserData build() {
            return new UserData(this);
        }
    }
}
