/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusInfo implements ToCopyableBuilder<VolumeStatusInfo.Builder, VolumeStatusInfo> {
    private final List<VolumeStatusDetails> details;

    private final String status;

    private VolumeStatusInfo(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * <p>
     * The details of the volume status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details of the volume status.
     */
    public List<VolumeStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeStatusInfoStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatusInfoStatus
     */
    public VolumeStatusInfoStatus status() {
        return VolumeStatusInfoStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeStatusInfoStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatusInfoStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusInfo)) {
            return false;
        }
        VolumeStatusInfo other = (VolumeStatusInfo) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.of(clazz.cast(details()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusInfo> {
        /**
         * <p>
         * The details of the volume status.
         * </p>
         * 
         * @param details
         *        The details of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<VolumeStatusDetails> details);

        /**
         * <p>
         * The details of the volume status.
         * </p>
         * 
         * @param details
         *        The details of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(VolumeStatusDetails... details);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param status
         *        The status of the volume.
         * @see VolumeStatusInfoStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusInfoStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param status
         *        The status of the volume.
         * @see VolumeStatusInfoStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusInfoStatus
         */
        Builder status(VolumeStatusInfoStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeStatusDetails> details;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusInfo model) {
            details(model.details);
            status(model.status);
        }

        public final Collection<VolumeStatusDetails.Builder> getDetails() {
            return details != null ? details.stream().map(VolumeStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(VolumeStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<VolumeStatusDetails.BuilderImpl> details) {
            this.details = VolumeStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeStatusInfoStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public VolumeStatusInfo build() {
            return new VolumeStatusInfo(this);
        }
    }
}
