/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeConversionTasksResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeConversionTasksResponseUnmarshaller implements
        Unmarshaller<DescribeConversionTasksResponse, StaxUnmarshallerContext> {

    public DescribeConversionTasksResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeConversionTasksResponse.Builder describeConversionTasksResponse = DescribeConversionTasksResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ConversionTask> conversionTasks = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeConversionTasksResponse.conversionTasks(conversionTasks);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("conversionTasks", targetDepth)) {
                    conversionTasks = new ArrayList<ConversionTask>();
                    continue;
                }

                if (context.testExpression("conversionTasks/item", targetDepth)) {
                    conversionTasks.add(ConversionTaskUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeConversionTasksResponse.conversionTasks(conversionTasks);
                    break;
                }
            }
        }
        return describeConversionTasksResponse.build();
    }

    private static final DescribeConversionTasksResponseUnmarshaller INSTANCE = new DescribeConversionTasksResponseUnmarshaller();

    public static DescribeConversionTasksResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
