/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeVpcEndpointServicesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVpcEndpointServicesResponseUnmarshaller implements
        Unmarshaller<DescribeVpcEndpointServicesResponse, StaxUnmarshallerContext> {

    public DescribeVpcEndpointServicesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeVpcEndpointServicesResponse.Builder describeVpcEndpointServicesResponse = DescribeVpcEndpointServicesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> serviceNames = null;
        java.util.List<ServiceDetail> serviceDetails = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeVpcEndpointServicesResponse.serviceNames(serviceNames);
                describeVpcEndpointServicesResponse.serviceDetails(serviceDetails);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("serviceNameSet", targetDepth)) {
                    serviceNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("serviceNameSet/item", targetDepth)) {
                    serviceNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("serviceDetailSet", targetDepth)) {
                    serviceDetails = new ArrayList<ServiceDetail>();
                    continue;
                }

                if (context.testExpression("serviceDetailSet/item", targetDepth)) {
                    serviceDetails.add(ServiceDetailUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeVpcEndpointServicesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeVpcEndpointServicesResponse.serviceNames(serviceNames);
                    describeVpcEndpointServicesResponse.serviceDetails(serviceDetails);
                    break;
                }
            }
        }
        return describeVpcEndpointServicesResponse.build();
    }

    private static final DescribeVpcEndpointServicesResponseUnmarshaller INSTANCE = new DescribeVpcEndpointServicesResponseUnmarshaller();

    public static DescribeVpcEndpointServicesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
