/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LaunchSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LaunchSpecificationUnmarshaller implements Unmarshaller<LaunchSpecification, StaxUnmarshallerContext> {

    public LaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchSpecification.Builder launchSpecification = LaunchSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<BlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<InstanceNetworkInterfaceSpecification> networkInterfaces = null;
        java.util.List<GroupIdentifier> allSecurityGroups = null;
        java.util.List<String> securityGroups = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                launchSpecification.blockDeviceMappings(blockDeviceMappings);
                launchSpecification.networkInterfaces(networkInterfaces);
                launchSpecification.allSecurityGroups(allSecurityGroups);
                launchSpecification.securityGroups(securityGroups);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("userData", targetDepth)) {
                    launchSpecification.userData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("addressingType", targetDepth)) {
                    launchSpecification.addressingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ebsOptimized", targetDepth)) {
                    launchSpecification.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("iamInstanceProfile", targetDepth)) {
                    launchSpecification.iamInstanceProfile(IamInstanceProfileSpecificationUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("imageId", targetDepth)) {
                    launchSpecification.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    launchSpecification.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernelId", targetDepth)) {
                    launchSpecification.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("keyName", targetDepth)) {
                    launchSpecification.keyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceSet", targetDepth)) {
                    networkInterfaces = new ArrayList<InstanceNetworkInterfaceSpecification>();
                    continue;
                }

                if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                    networkInterfaces.add(InstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("placement", targetDepth)) {
                    launchSpecification.placement(SpotPlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdiskId", targetDepth)) {
                    launchSpecification.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    launchSpecification.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    allSecurityGroups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    allSecurityGroups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("monitoring/enabled", targetDepth)) {
                    launchSpecification.monitoringEnabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("securityGroup", targetDepth)) {
                    securityGroups = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("securityGroup/GroupName", targetDepth)) {
                    securityGroups.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    launchSpecification.blockDeviceMappings(blockDeviceMappings);
                    launchSpecification.networkInterfaces(networkInterfaces);
                    launchSpecification.allSecurityGroups(allSecurityGroups);
                    launchSpecification.securityGroups(securityGroups);
                    break;
                }
            }
        }
        return launchSpecification.build();
    }

    private static final LaunchSpecificationUnmarshaller INSTANCE = new LaunchSpecificationUnmarshaller();

    public static LaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
