/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Reservation StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReservationUnmarshaller implements Unmarshaller<Reservation, StaxUnmarshallerContext> {

    public Reservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        Reservation.Builder reservation = Reservation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> groups = null;
        java.util.List<Instance> instances = null;
        java.util.List<String> groupNames = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                reservation.groups(groups);
                reservation.instances(instances);
                reservation.groupNames(groupNames);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instancesSet", targetDepth)) {
                    instances = new ArrayList<Instance>();
                    continue;
                }

                if (context.testExpression("instancesSet/item", targetDepth)) {
                    instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    reservation.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("requesterId", targetDepth)) {
                    reservation.requesterId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservationId", targetDepth)) {
                    reservation.reservationId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupName", targetDepth)) {
                    groupNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("groupName/GroupName", targetDepth)) {
                    groupNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    reservation.groups(groups);
                    reservation.instances(instances);
                    reservation.groupNames(groupNames);
                    break;
                }
            }
        }
        return reservation.build();
    }

    private static final ReservationUnmarshaller INSTANCE = new ReservationUnmarshaller();

    public static ReservationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
