/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * RouteTable StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RouteTableUnmarshaller implements Unmarshaller<RouteTable, StaxUnmarshallerContext> {

    public RouteTable unmarshall(StaxUnmarshallerContext context) throws Exception {
        RouteTable.Builder routeTable = RouteTable.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<RouteTableAssociation> associations = null;
        java.util.List<PropagatingVgw> propagatingVgws = null;
        java.util.List<Route> routes = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                routeTable.associations(associations);
                routeTable.propagatingVgws(propagatingVgws);
                routeTable.routes(routes);
                routeTable.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("associationSet", targetDepth)) {
                    associations = new ArrayList<RouteTableAssociation>();
                    continue;
                }

                if (context.testExpression("associationSet/item", targetDepth)) {
                    associations.add(RouteTableAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("propagatingVgwSet", targetDepth)) {
                    propagatingVgws = new ArrayList<PropagatingVgw>();
                    continue;
                }

                if (context.testExpression("propagatingVgwSet/item", targetDepth)) {
                    propagatingVgws.add(PropagatingVgwUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("routeTableId", targetDepth)) {
                    routeTable.routeTableId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("routeSet", targetDepth)) {
                    routes = new ArrayList<Route>();
                    continue;
                }

                if (context.testExpression("routeSet/item", targetDepth)) {
                    routes.add(RouteUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    routeTable.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    routeTable.associations(associations);
                    routeTable.propagatingVgws(propagatingVgws);
                    routeTable.routes(routes);
                    routeTable.tags(tags);
                    break;
                }
            }
        }
        return routeTable.build();
    }

    private static final RouteTableUnmarshaller INSTANCE = new RouteTableUnmarshaller();

    public static RouteTableUnmarshaller getInstance() {
        return INSTANCE;
    }
}
