/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * StaleIpPermission StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StaleIpPermissionUnmarshaller implements Unmarshaller<StaleIpPermission, StaxUnmarshallerContext> {

    public StaleIpPermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        StaleIpPermission.Builder staleIpPermission = StaleIpPermission.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> ipRanges = null;
        java.util.List<String> prefixListIds = null;
        java.util.List<UserIdGroupPair> userIdGroupPairs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                staleIpPermission.ipRanges(ipRanges);
                staleIpPermission.prefixListIds(prefixListIds);
                staleIpPermission.userIdGroupPairs(userIdGroupPairs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("fromPort", targetDepth)) {
                    staleIpPermission.fromPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipProtocol", targetDepth)) {
                    staleIpPermission.ipProtocol(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipRanges", targetDepth)) {
                    ipRanges = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("ipRanges/item", targetDepth)) {
                    ipRanges.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("prefixListIds", targetDepth)) {
                    prefixListIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("prefixListIds/item", targetDepth)) {
                    prefixListIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("toPort", targetDepth)) {
                    staleIpPermission.toPort(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groups", targetDepth)) {
                    userIdGroupPairs = new ArrayList<UserIdGroupPair>();
                    continue;
                }

                if (context.testExpression("groups/item", targetDepth)) {
                    userIdGroupPairs.add(UserIdGroupPairUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    staleIpPermission.ipRanges(ipRanges);
                    staleIpPermission.prefixListIds(prefixListIds);
                    staleIpPermission.userIdGroupPairs(userIdGroupPairs);
                    break;
                }
            }
        }
        return staleIpPermission.build();
    }

    private static final StaleIpPermissionUnmarshaller INSTANCE = new StaleIpPermissionUnmarshaller();

    public static StaleIpPermissionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
