/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * UnassignIpv6AddressesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UnassignIpv6AddressesRequestMarshaller implements
        Marshaller<Request<UnassignIpv6AddressesRequest>, UnassignIpv6AddressesRequest> {

    public Request<UnassignIpv6AddressesRequest> marshall(UnassignIpv6AddressesRequest unassignIpv6AddressesRequest) {

        if (unassignIpv6AddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UnassignIpv6AddressesRequest> request = new DefaultRequest<UnassignIpv6AddressesRequest>(
                unassignIpv6AddressesRequest, "EC2Client");
        request.addParameter("Action", "UnassignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> unassignIpv6AddressesRequestIpv6AddressesList = unassignIpv6AddressesRequest.ipv6Addresses();
        if (unassignIpv6AddressesRequestIpv6AddressesList != null) {
            int ipv6AddressesListIndex = 1;

            for (String unassignIpv6AddressesRequestIpv6AddressesListValue : unassignIpv6AddressesRequestIpv6AddressesList) {
                if (unassignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex,
                            StringUtils.fromString(unassignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ipv6AddressesListIndex++;
            }
        }

        if (unassignIpv6AddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(unassignIpv6AddressesRequest.networkInterfaceId()));
        }

        return request;
    }

}
