/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * VpcEndpoint StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VpcEndpointUnmarshaller implements Unmarshaller<VpcEndpoint, StaxUnmarshallerContext> {

    public VpcEndpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpcEndpoint.Builder vpcEndpoint = VpcEndpoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> routeTableIds = null;
        java.util.List<String> subnetIds = null;
        java.util.List<SecurityGroupIdentifier> groups = null;
        java.util.List<String> networkInterfaceIds = null;
        java.util.List<DnsEntry> dnsEntries = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                vpcEndpoint.routeTableIds(routeTableIds);
                vpcEndpoint.subnetIds(subnetIds);
                vpcEndpoint.groups(groups);
                vpcEndpoint.networkInterfaceIds(networkInterfaceIds);
                vpcEndpoint.dnsEntries(dnsEntries);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("vpcEndpointId", targetDepth)) {
                    vpcEndpoint.vpcEndpointId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcEndpointType", targetDepth)) {
                    vpcEndpoint.vpcEndpointType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    vpcEndpoint.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("serviceName", targetDepth)) {
                    vpcEndpoint.serviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    vpcEndpoint.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("policyDocument", targetDepth)) {
                    vpcEndpoint.policyDocument(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("routeTableIdSet", targetDepth)) {
                    routeTableIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("routeTableIdSet/item", targetDepth)) {
                    routeTableIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetIdSet", targetDepth)) {
                    subnetIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("subnetIdSet/item", targetDepth)) {
                    subnetIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<SecurityGroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(SecurityGroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateDnsEnabled", targetDepth)) {
                    vpcEndpoint.privateDnsEnabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceIdSet", targetDepth)) {
                    networkInterfaceIds = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("networkInterfaceIdSet/item", targetDepth)) {
                    networkInterfaceIds.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("dnsEntrySet", targetDepth)) {
                    dnsEntries = new ArrayList<DnsEntry>();
                    continue;
                }

                if (context.testExpression("dnsEntrySet/item", targetDepth)) {
                    dnsEntries.add(DnsEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("creationTimestamp", targetDepth)) {
                    vpcEndpoint.creationTimestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    vpcEndpoint.routeTableIds(routeTableIds);
                    vpcEndpoint.subnetIds(subnetIds);
                    vpcEndpoint.groups(groups);
                    vpcEndpoint.networkInterfaceIds(networkInterfaceIds);
                    vpcEndpoint.dnsEntries(dnsEntries);
                    break;
                }
            }
        }
        return vpcEndpoint.build();
    }

    private static final VpcEndpointUnmarshaller INSTANCE = new VpcEndpointUnmarshaller();

    public static VpcEndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}
