/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AcceptVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AcceptVpcPeeringConnectionRequest extends EC2Request implements
        ToCopyableBuilder<AcceptVpcPeeringConnectionRequest.Builder, AcceptVpcPeeringConnectionRequest> {
    private final String vpcPeeringConnectionId;

    private AcceptVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptVpcPeeringConnectionRequest)) {
            return false;
        }
        AcceptVpcPeeringConnectionRequest other = (AcceptVpcPeeringConnectionRequest) obj;
        return Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AcceptVpcPeeringConnectionRequest> {
        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptVpcPeeringConnectionRequest model) {
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AcceptVpcPeeringConnectionRequest build() {
            return new AcceptVpcPeeringConnectionRequest(this);
        }
    }
}
