/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AllocateHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllocateHostsRequest extends EC2Request implements
        ToCopyableBuilder<AllocateHostsRequest.Builder, AllocateHostsRequest> {
    private final String autoPlacement;

    private final String availabilityZone;

    private final String clientToken;

    private final String instanceType;

    private final Integer quantity;

    private AllocateHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * This is enabled by default. This property allows instances to be automatically placed onto available Dedicated
     * Hosts, when you are launching instances without specifying a host ID.
     * </p>
     * <p>
     * Default: Enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementString}.
     * </p>
     * 
     * @return This is enabled by default. This property allows instances to be automatically placed onto available
     *         Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
     *         <p>
     *         Default: Enabled
     * @see AutoPlacement
     */
    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * This is enabled by default. This property allows instances to be automatically placed onto available Dedicated
     * Hosts, when you are launching instances without specifying a host ID.
     * </p>
     * <p>
     * Default: Enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementString}.
     * </p>
     * 
     * @return This is enabled by default. This property allows instances to be automatically placed onto available
     *         Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
     *         <p>
     *         Default: Enabled
     * @see AutoPlacement
     */
    public String autoPlacementString() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone for the Dedicated Hosts.
     * </p>
     * 
     * @return The Availability Zone for the Dedicated Hosts.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the instance
     * type, that is the only instance type that you can launch onto that host.
     * </p>
     * 
     * @return Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the
     *         instance type, that is the only instance type that you can launch onto that host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of Dedicated Hosts you want to allocate to your account with these parameters.
     * </p>
     * 
     * @return The number of Dedicated Hosts you want to allocate to your account with these parameters.
     */
    public Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest) obj;
        return Objects.equals(autoPlacementString(), other.autoPlacementString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(quantity(), other.quantity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoPlacementString() != null) {
            sb.append("AutoPlacement: ").append(autoPlacementString()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.of(clazz.cast(autoPlacementString()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AllocateHostsRequest> {
        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone for the Dedicated Hosts.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the
         * instance type, that is the only instance type that you can launch onto that host.
         * </p>
         * 
         * @param instanceType
         *        Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify
         *        the instance type, that is the only instance type that you can launch onto that host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of Dedicated Hosts you want to allocate to your account with these parameters.
         * </p>
         * 
         * @param quantity
         *        The number of Dedicated Hosts you want to allocate to your account with these parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private String clientToken;

        private String instanceType;

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            autoPlacement(model.autoPlacement);
            availabilityZone(model.availabilityZone);
            clientToken(model.clientToken);
            instanceType(model.instanceType);
            quantity(model.quantity);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }
    }
}
