/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for CancelImportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelImportTaskResponse extends EC2Response implements
        ToCopyableBuilder<CancelImportTaskResponse.Builder, CancelImportTaskResponse> {
    private final String importTaskId;

    private final String previousState;

    private final String state;

    private CancelImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.importTaskId = builder.importTaskId;
        this.previousState = builder.previousState;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the task being canceled.
     * </p>
     * 
     * @return The ID of the task being canceled.
     */
    public String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The current state of the task being canceled.
     * </p>
     * 
     * @return The current state of the task being canceled.
     */
    public String previousState() {
        return previousState;
    }

    /**
     * <p>
     * The current state of the task being canceled.
     * </p>
     * 
     * @return The current state of the task being canceled.
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(previousState());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskResponse)) {
            return false;
        }
        CancelImportTaskResponse other = (CancelImportTaskResponse) obj;
        return Objects.equals(importTaskId(), other.importTaskId()) && Objects.equals(previousState(), other.previousState())
                && Objects.equals(state(), other.state());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (importTaskId() != null) {
            sb.append("ImportTaskId: ").append(importTaskId()).append(",");
        }
        if (previousState() != null) {
            sb.append("PreviousState: ").append(previousState()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportTaskId":
            return Optional.of(clazz.cast(importTaskId()));
        case "PreviousState":
            return Optional.of(clazz.cast(previousState()));
        case "State":
            return Optional.of(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CancelImportTaskResponse> {
        /**
         * <p>
         * The ID of the task being canceled.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The current state of the task being canceled.
         * </p>
         * 
         * @param previousState
         *        The current state of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousState(String previousState);

        /**
         * <p>
         * The current state of the task being canceled.
         * </p>
         * 
         * @param state
         *        The current state of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String importTaskId;

        private String previousState;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskResponse model) {
            importTaskId(model.importTaskId);
            previousState(model.previousState);
            state(model.state);
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getPreviousState() {
            return previousState;
        }

        @Override
        public final Builder previousState(String previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(String previousState) {
            this.previousState = previousState;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public CancelImportTaskResponse build() {
            return new CancelImportTaskResponse(this);
        }
    }
}
