/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 CIDR block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CidrBlock implements ToCopyableBuilder<CidrBlock.Builder, CidrBlock> {
    private final String cidrBlock;

    private CidrBlock(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
    }

    /**
     * <p>
     * The IPv4 CIDR block.
     * </p>
     * 
     * @return The IPv4 CIDR block.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrBlock)) {
            return false;
        }
        CidrBlock other = (CidrBlock) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CidrBlock> {
        /**
         * <p>
         * The IPv4 CIDR block.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CidrBlock model) {
            cidrBlock(model.cidrBlock);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public CidrBlock build() {
            return new CidrBlock(this);
        }
    }
}
