/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Classic Load Balancers to attach to a Spot fleet. Spot fleet registers the running Spot instances with
 * these Classic Load Balancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClassicLoadBalancersConfig implements
        ToCopyableBuilder<ClassicLoadBalancersConfig.Builder, ClassicLoadBalancersConfig> {
    private final List<ClassicLoadBalancer> classicLoadBalancers;

    private ClassicLoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancers = builder.classicLoadBalancers;
    }

    /**
     * <p>
     * One or more Classic Load Balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Classic Load Balancers.
     */
    public List<ClassicLoadBalancer> classicLoadBalancers() {
        return classicLoadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classicLoadBalancers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLoadBalancersConfig)) {
            return false;
        }
        ClassicLoadBalancersConfig other = (ClassicLoadBalancersConfig) obj;
        return Objects.equals(classicLoadBalancers(), other.classicLoadBalancers());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (classicLoadBalancers() != null) {
            sb.append("ClassicLoadBalancers: ").append(classicLoadBalancers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLoadBalancers":
            return Optional.of(clazz.cast(classicLoadBalancers()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ClassicLoadBalancersConfig> {
        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers);

        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private List<ClassicLoadBalancer> classicLoadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLoadBalancersConfig model) {
            classicLoadBalancers(model.classicLoadBalancers);
        }

        public final Collection<ClassicLoadBalancer.Builder> getClassicLoadBalancers() {
            return classicLoadBalancers != null ? classicLoadBalancers.stream().map(ClassicLoadBalancer::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copy(classicLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers) {
            classicLoadBalancers(Arrays.asList(classicLoadBalancers));
            return this;
        }

        public final void setClassicLoadBalancers(Collection<ClassicLoadBalancer.BuilderImpl> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copyFromBuilder(classicLoadBalancers);
        }

        @Override
        public ClassicLoadBalancersConfig build() {
            return new ClassicLoadBalancersConfig(this);
        }
    }
}
