/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateEgressOnlyInternetGatewayResponse extends EC2Response implements
        ToCopyableBuilder<CreateEgressOnlyInternetGatewayResponse.Builder, CreateEgressOnlyInternetGatewayResponse> {
    private final String clientToken;

    private final EgressOnlyInternetGateway egressOnlyInternetGateway;

    private CreateEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Information about the egress-only Internet gateway.
     * </p>
     * 
     * @return Information about the egress-only Internet gateway.
     */
    public EgressOnlyInternetGateway egressOnlyInternetGateway() {
        return egressOnlyInternetGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        CreateEgressOnlyInternetGatewayResponse other = (CreateEgressOnlyInternetGatewayResponse) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(egressOnlyInternetGateway(), other.egressOnlyInternetGateway());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (egressOnlyInternetGateway() != null) {
            sb.append("EgressOnlyInternetGateway: ").append(egressOnlyInternetGateway()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "EgressOnlyInternetGateway":
            return Optional.of(clazz.cast(egressOnlyInternetGateway()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGateway
         *        Information about the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway);

        /**
         * <p>
         * Information about the egress-only Internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link EgressOnlyInternetGateway.Builder} avoiding the
         * need to create one manually via {@link EgressOnlyInternetGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressOnlyInternetGateway.Builder#build()} is called immediately
         * and its result is passed to {@link #egressOnlyInternetGateway(EgressOnlyInternetGateway)}.
         * 
         * @param egressOnlyInternetGateway
         *        a consumer that will call methods on {@link EgressOnlyInternetGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressOnlyInternetGateway(EgressOnlyInternetGateway)
         */
        default Builder egressOnlyInternetGateway(Consumer<EgressOnlyInternetGateway.Builder> egressOnlyInternetGateway) {
            return egressOnlyInternetGateway(EgressOnlyInternetGateway.builder().apply(egressOnlyInternetGateway).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String clientToken;

        private EgressOnlyInternetGateway egressOnlyInternetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEgressOnlyInternetGatewayResponse model) {
            clientToken(model.clientToken);
            egressOnlyInternetGateway(model.egressOnlyInternetGateway);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final EgressOnlyInternetGateway.Builder getEgressOnlyInternetGateway() {
            return egressOnlyInternetGateway != null ? egressOnlyInternetGateway.toBuilder() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final void setEgressOnlyInternetGateway(EgressOnlyInternetGateway.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        @Override
        public CreateEgressOnlyInternetGatewayResponse build() {
            return new CreateEgressOnlyInternetGatewayResponse(this);
        }
    }
}
