/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFlowLogsRequest extends EC2Request implements
        ToCopyableBuilder<CreateFlowLogsRequest.Builder, CreateFlowLogsRequest> {
    private final String clientToken;

    private final String deliverLogsPermissionArn;

    private final String logGroupName;

    private final List<String> resourceIds;

    private final String resourceType;

    private final String trafficType;

    private CreateFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.logGroupName = builder.logGroupName;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.trafficType = builder.trafficType;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group.
     * </p>
     * 
     * @return The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group.
     */
    public String deliverLogsPermissionArn() {
        return deliverLogsPermissionArn;
    }

    /**
     * <p>
     * The name of the CloudWatch log group.
     * </p>
     * 
     * @return The name of the CloudWatch log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * One or more subnet, network interface, or VPC IDs.
     * </p>
     * <p>
     * Constraints: Maximum of 1000 resources
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more subnet, network interface, or VPC IDs.</p>
     *         <p>
     *         Constraints: Maximum of 1000 resources
     */
    public List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The type of resource on which to create the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FlowLogsResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource on which to create the flow log.
     * @see FlowLogsResourceType
     */
    public FlowLogsResourceType resourceType() {
        return FlowLogsResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource on which to create the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FlowLogsResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource on which to create the flow log.
     * @see FlowLogsResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The type of traffic to log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeString}.
     * </p>
     * 
     * @return The type of traffic to log.
     * @see TrafficType
     */
    public TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * The type of traffic to log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeString}.
     * </p>
     * 
     * @return The type of traffic to log.
     * @see TrafficType
     */
    public String trafficTypeString() {
        return trafficType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(deliverLogsPermissionArn(), other.deliverLogsPermissionArn())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(trafficTypeString(), other.trafficTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (deliverLogsPermissionArn() != null) {
            sb.append("DeliverLogsPermissionArn: ").append(deliverLogsPermissionArn()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (resourceIds() != null) {
            sb.append("ResourceIds: ").append(resourceIds()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (trafficTypeString() != null) {
            sb.append("TrafficType: ").append(trafficTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "DeliverLogsPermissionArn":
            return Optional.of(clazz.cast(deliverLogsPermissionArn()));
        case "LogGroupName":
            return Optional.of(clazz.cast(logGroupName()));
        case "ResourceIds":
            return Optional.of(clazz.cast(resourceIds()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "TrafficType":
            return Optional.of(clazz.cast(trafficTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateFlowLogsRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group.
         * </p>
         * 
         * @param deliverLogsPermissionArn
         *        The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsPermissionArn(String deliverLogsPermissionArn);

        /**
         * <p>
         * The name of the CloudWatch log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the CloudWatch log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * One or more subnet, network interface, or VPC IDs.
         * </p>
         * <p>
         * Constraints: Maximum of 1000 resources
         * </p>
         * 
         * @param resourceIds
         *        One or more subnet, network interface, or VPC IDs.</p>
         *        <p>
         *        Constraints: Maximum of 1000 resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * One or more subnet, network interface, or VPC IDs.
         * </p>
         * <p>
         * Constraints: Maximum of 1000 resources
         * </p>
         * 
         * @param resourceIds
         *        One or more subnet, network interface, or VPC IDs.</p>
         *        <p>
         *        Constraints: Maximum of 1000 resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The type of resource on which to create the flow log.
         * </p>
         * 
         * @param resourceType
         *        The type of resource on which to create the flow log.
         * @see FlowLogsResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowLogsResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource on which to create the flow log.
         * </p>
         * 
         * @param resourceType
         *        The type of resource on which to create the flow log.
         * @see FlowLogsResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowLogsResourceType
         */
        Builder resourceType(FlowLogsResourceType resourceType);

        /**
         * <p>
         * The type of traffic to log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic to log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * The type of traffic to log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic to log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String deliverLogsPermissionArn;

        private String logGroupName;

        private List<String> resourceIds;

        private String resourceType;

        private String trafficType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsRequest model) {
            clientToken(model.clientToken);
            deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            logGroupName(model.logGroupName);
            resourceIds(model.resourceIds);
            resourceType(model.resourceType);
            trafficType(model.trafficType);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDeliverLogsPermissionArn() {
            return deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getResourceIds() {
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FlowLogsResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTrafficType() {
            return trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowLogsRequest build() {
            return new CreateFlowLogsRequest(this);
        }
    }
}
