/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateImageRequest extends EC2Request implements ToCopyableBuilder<CreateImageRequest.Builder, CreateImageRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final String instanceId;

    private final String name;

    private final Boolean noReboot;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.noReboot = builder.noReboot;
    }

    /**
     * <p>
     * Information about one or more block device mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more block device mappings.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * A description for the new image.
     * </p>
     * 
     * @return A description for the new image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A name for the new image.
     * </p>
     * <p>
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
     * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     * </p>
     * 
     * @return A name for the new image.</p>
     *         <p>
     *         Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods
     *         (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the 'No
     * Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option is
     * used, file system integrity on the created image can't be guaranteed.
     * </p>
     * 
     * @return By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the
     *         'No Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this
     *         option is used, file system integrity on the created image can't be guaranteed.
     */
    public Boolean noReboot() {
        return noReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(noReboot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest) obj;
        return Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(name(), other.name()) && Objects.equals(noReboot(), other.noReboot());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (noReboot() != null) {
            sb.append("NoReboot: ").append(noReboot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "NoReboot":
            return Optional.of(clazz.cast(noReboot()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateImageRequest> {
        /**
         * <p>
         * Information about one or more block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Information about one or more block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Information about one or more block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Information about one or more block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * A description for the new image.
         * </p>
         * 
         * @param description
         *        A description for the new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A name for the new image.
         * </p>
         * <p>
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
         * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * </p>
         * 
         * @param name
         *        A name for the new image.</p>
         *        <p>
         *        Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ),
         *        periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the 'No
         * Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option
         * is used, file system integrity on the created image can't be guaranteed.
         * </p>
         * 
         * @param noReboot
         *        By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the
         *        'No Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When
         *        this option is used, file system integrity on the created image can't be guaranteed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noReboot(Boolean noReboot);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;

        private String description;

        private String instanceId;

        private String name;

        private Boolean noReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            instanceId(model.instanceId);
            name(model.name);
            noReboot(model.noReboot);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoReboot() {
            return noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }
    }
}
