/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateNetworkInterfacePermission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNetworkInterfacePermissionRequest extends EC2Request implements
        ToCopyableBuilder<CreateNetworkInterfacePermissionRequest.Builder, CreateNetworkInterfacePermissionRequest> {
    private final String networkInterfaceId;

    private final String awsAccountId;

    private final String awsService;

    private final String permission;

    private CreateNetworkInterfacePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The AWS service. Currently not supported.
     * </p>
     * 
     * @return The AWS service. Currently not supported.
     */
    public String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The type of permission to grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return The type of permission to grant.
     * @see InterfacePermissionType
     */
    public InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission to grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return The type of permission to grant.
     * @see InterfacePermissionType
     */
    public String permissionString() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(permissionString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfacePermissionRequest)) {
            return false;
        }
        CreateNetworkInterfacePermissionRequest other = (CreateNetworkInterfacePermissionRequest) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsService(), other.awsService())
                && Objects.equals(permissionString(), other.permissionString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (awsAccountId() != null) {
            sb.append("AwsAccountId: ").append(awsAccountId()).append(",");
        }
        if (awsService() != null) {
            sb.append("AwsService: ").append(awsService()).append(",");
        }
        if (permissionString() != null) {
            sb.append("Permission: ").append(permissionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "AwsAccountId":
            return Optional.of(clazz.cast(awsAccountId()));
        case "AwsService":
            return Optional.of(clazz.cast(awsService()));
        case "Permission":
            return Optional.of(clazz.cast(permissionString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateNetworkInterfacePermissionRequest> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The AWS service. Currently not supported.
         * </p>
         * 
         * @param awsService
         *        The AWS service. Currently not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The type of permission to grant.
         * </p>
         * 
         * @param permission
         *        The type of permission to grant.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission to grant.
         * </p>
         * 
         * @param permission
         *        The type of permission to grant.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(InterfacePermissionType permission);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String awsAccountId;

        private String awsService;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfacePermissionRequest model) {
            networkInterfaceId(model.networkInterfaceId);
            awsAccountId(model.awsAccountId);
            awsService(model.awsService);
            permission(model.permission);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAwsService() {
            return awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInterfacePermissionRequest build() {
            return new CreateNetworkInterfacePermissionRequest(this);
        }
    }
}
