/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes modifications to the permissions for a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVolumePermissionModifications implements
        ToCopyableBuilder<CreateVolumePermissionModifications.Builder, CreateVolumePermissionModifications> {
    private final List<CreateVolumePermission> add;

    private final List<CreateVolumePermission> remove;

    private CreateVolumePermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * <p>
     * Adds a specific AWS account ID or group to a volume's list of create volume permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Adds a specific AWS account ID or group to a volume's list of create volume permissions.
     */
    public List<CreateVolumePermission> add() {
        return add;
    }

    /**
     * <p>
     * Removes a specific AWS account ID or group from a volume's list of create volume permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Removes a specific AWS account ID or group from a volume's list of create volume permissions.
     */
    public List<CreateVolumePermission> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(add());
        hashCode = 31 * hashCode + Objects.hashCode(remove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumePermissionModifications)) {
            return false;
        }
        CreateVolumePermissionModifications other = (CreateVolumePermissionModifications) obj;
        return Objects.equals(add(), other.add()) && Objects.equals(remove(), other.remove());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (add() != null) {
            sb.append("Add: ").append(add()).append(",");
        }
        if (remove() != null) {
            sb.append("Remove: ").append(remove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.of(clazz.cast(add()));
        case "Remove":
            return Optional.of(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVolumePermissionModifications> {
        /**
         * <p>
         * Adds a specific AWS account ID or group to a volume's list of create volume permissions.
         * </p>
         * 
         * @param add
         *        Adds a specific AWS account ID or group to a volume's list of create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<CreateVolumePermission> add);

        /**
         * <p>
         * Adds a specific AWS account ID or group to a volume's list of create volume permissions.
         * </p>
         * 
         * @param add
         *        Adds a specific AWS account ID or group to a volume's list of create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(CreateVolumePermission... add);

        /**
         * <p>
         * Removes a specific AWS account ID or group from a volume's list of create volume permissions.
         * </p>
         * 
         * @param remove
         *        Removes a specific AWS account ID or group from a volume's list of create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<CreateVolumePermission> remove);

        /**
         * <p>
         * Removes a specific AWS account ID or group from a volume's list of create volume permissions.
         * </p>
         * 
         * @param remove
         *        Removes a specific AWS account ID or group from a volume's list of create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(CreateVolumePermission... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<CreateVolumePermission> add;

        private List<CreateVolumePermission> remove;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumePermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<CreateVolumePermission.Builder> getAdd() {
            return add != null ? add.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<CreateVolumePermission> add) {
            this.add = CreateVolumePermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(CreateVolumePermission... add) {
            add(Arrays.asList(add));
            return this;
        }

        public final void setAdd(Collection<CreateVolumePermission.BuilderImpl> add) {
            this.add = CreateVolumePermissionListCopier.copyFromBuilder(add);
        }

        public final Collection<CreateVolumePermission.Builder> getRemove() {
            return remove != null ? remove.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<CreateVolumePermission> remove) {
            this.remove = CreateVolumePermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(CreateVolumePermission... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        public final void setRemove(Collection<CreateVolumePermission.BuilderImpl> remove) {
            this.remove = CreateVolumePermissionListCopier.copyFromBuilder(remove);
        }

        @Override
        public CreateVolumePermissionModifications build() {
            return new CreateVolumePermissionModifications(this);
        }
    }
}
