/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcResponse extends EC2Response implements ToCopyableBuilder<CreateVpcResponse.Builder, CreateVpcResponse> {
    private final Vpc vpc;

    private CreateVpcResponse(BuilderImpl builder) {
        super(builder);
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * Information about the VPC.
     * </p>
     * 
     * @return Information about the VPC.
     */
    public Vpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcResponse)) {
            return false;
        }
        CreateVpcResponse other = (CreateVpcResponse) obj;
        return Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpc() != null) {
            sb.append("Vpc: ").append(vpc()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpc":
            return Optional.of(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateVpcResponse> {
        /**
         * <p>
         * Information about the VPC.
         * </p>
         * 
         * @param vpc
         *        Information about the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(Vpc vpc);

        /**
         * <p>
         * Information about the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link Vpc.Builder} avoiding the need to create one
         * manually via {@link Vpc#builder()}.
         *
         * When the {@link Consumer} completes, {@link Vpc.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(Vpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link Vpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(Vpc)
         */
        default Builder vpc(Consumer<Vpc.Builder> vpc) {
            return vpc(Vpc.builder().apply(vpc).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Vpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcResponse model) {
            vpc(model.vpc);
        }

        public final Vpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(Vpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public CreateVpcResponse build() {
            return new CreateVpcResponse(this);
        }
    }
}
