/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeAvailabilityZones.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAvailabilityZonesRequest extends EC2Request implements
        ToCopyableBuilder<DescribeAvailabilityZonesRequest.Builder, DescribeAvailabilityZonesRequest> {
    private final List<Filter> filters;

    private final List<String> zoneNames;

    private DescribeAvailabilityZonesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.zoneNames = builder.zoneNames;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>message</code> - Information about the Availability Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region-name</code> - The name of the region for the Availability Zone (for example, <code>us-east-1</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
     * <code>impaired</code> | <code>unavailable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>message</code> - Information about the Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region-name</code> - The name of the region for the Availability Zone (for example,
     *         <code>us-east-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Availability Zone (<code>available</code> |
     *         <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The names of one or more Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more Availability Zones.
     */
    public List<String> zoneNames() {
        return zoneNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(zoneNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(zoneNames(), other.zoneNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (zoneNames() != null) {
            sb.append("ZoneNames: ").append(zoneNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "ZoneNames":
            return Optional.of(clazz.cast(zoneNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>message</code> - Information about the Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region for the Availability Zone (for example,
         * <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
         * <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>message</code> - Information about the Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region for the Availability Zone (for example,
         *        <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone (<code>available</code> |
         *        <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>message</code> - Information about the Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region for the Availability Zone (for example,
         * <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
         * <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>message</code> - Information about the Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region for the Availability Zone (for example,
         *        <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone (<code>available</code> |
         *        <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The names of one or more Availability Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(Collection<String> zoneNames);

        /**
         * <p>
         * The names of one or more Availability Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(String... zoneNames);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> zoneNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityZonesRequest model) {
            filters(model.filters);
            zoneNames(model.zoneNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getZoneNames() {
            return zoneNames;
        }

        @Override
        public final Builder zoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneNames(String... zoneNames) {
            zoneNames(Arrays.asList(zoneNames));
            return this;
        }

        public final void setZoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAvailabilityZonesRequest build() {
            return new DescribeAvailabilityZonesRequest(this);
        }
    }
}
