/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDhcpOptionsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeDhcpOptionsResponse.Builder, DescribeDhcpOptionsResponse> {
    private final List<DhcpOptions> dhcpOptions;

    private DescribeDhcpOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dhcpOptions = builder.dhcpOptions;
    }

    /**
     * <p>
     * Information about one or more DHCP options sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more DHCP options sets.
     */
    public List<DhcpOptions> dhcpOptions() {
        return dhcpOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsResponse)) {
            return false;
        }
        DescribeDhcpOptionsResponse other = (DescribeDhcpOptionsResponse) obj;
        return Objects.equals(dhcpOptions(), other.dhcpOptions());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dhcpOptions() != null) {
            sb.append("DhcpOptions: ").append(dhcpOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptions":
            return Optional.of(clazz.cast(dhcpOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions... dhcpOptions);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<DhcpOptions> dhcpOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsResponse model) {
            dhcpOptions(model.dhcpOptions);
        }

        public final Collection<DhcpOptions.Builder> getDhcpOptions() {
            return dhcpOptions != null ? dhcpOptions.stream().map(DhcpOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(DhcpOptions... dhcpOptions) {
            dhcpOptions(Arrays.asList(dhcpOptions));
            return this;
        }

        public final void setDhcpOptions(Collection<DhcpOptions.BuilderImpl> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copyFromBuilder(dhcpOptions);
        }

        @Override
        public DescribeDhcpOptionsResponse build() {
            return new DescribeDhcpOptionsResponse(this);
        }
    }
}
