/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeHostReservationsRequest.Builder, DescribeHostReservationsRequest> {
    private final List<Filter> filter;

    private final List<String> hostReservationIdSet;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeHostReservationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.hostReservationIdSet = builder.hostReservationIdSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     * <code>AllUpfront</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> |
     * <code>active</code> | <code>retired</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     *         <code>AllUpfront</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the reservation (<code>payment-pending</code> |
     *         <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * One or more host reservation IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more host reservation IDs.
     */
    public List<String> hostReservationIdSet() {
        return hostReservationIdSet;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if
     * <code>maxResults</code> is given a larger value than 500, you will receive an error.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsRequest)) {
            return false;
        }
        DescribeHostReservationsRequest other = (DescribeHostReservationsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(hostReservationIdSet(), other.hostReservationIdSet())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (hostReservationIdSet() != null) {
            sb.append("HostReservationIdSet: ").append(hostReservationIdSet()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.of(clazz.cast(filter()));
        case "HostReservationIdSet":
            return Optional.of(clazz.cast(hostReservationIdSet()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeHostReservationsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code>
         * | <code>active</code> | <code>retired</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the reservation (<code>payment-pending</code> |
         *        <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code>
         * | <code>active</code> | <code>retired</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the reservation (<code>payment-pending</code> |
         *        <code>payment-failed</code> | <code>active</code> | <code>retired</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * One or more host reservation IDs.
         * </p>
         * 
         * @param hostReservationIdSet
         *        One or more host reservation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationIdSet(Collection<String> hostReservationIdSet);

        /**
         * <p>
         * One or more host reservation IDs.
         * </p>
         * 
         * @param hostReservationIdSet
         *        One or more host reservation IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationIdSet(String... hostReservationIdSet);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filter;

        private List<String> hostReservationIdSet;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsRequest model) {
            filter(model.filter);
            hostReservationIdSet(model.hostReservationIdSet);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilter() {
            return filter != null ? filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Collection<String> getHostReservationIdSet() {
            return hostReservationIdSet;
        }

        @Override
        public final Builder hostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationIdSet(String... hostReservationIdSet) {
            hostReservationIdSet(Arrays.asList(hostReservationIdSet));
            return this;
        }

        public final void setHostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostReservationsRequest build() {
            return new DescribeHostReservationsRequest(this);
        }
    }
}
