/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeIdFormat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIdFormatResponse extends EC2Response implements
        ToCopyableBuilder<DescribeIdFormatResponse.Builder, DescribeIdFormatResponse> {
    private final List<IdFormat> statuses;

    private DescribeIdFormatResponse(BuilderImpl builder) {
        super(builder);
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * Information about the ID format for the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the ID format for the resource.
     */
    public List<IdFormat> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdFormatResponse)) {
            return false;
        }
        DescribeIdFormatResponse other = (DescribeIdFormatResponse) obj;
        return Objects.equals(statuses(), other.statuses());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (statuses() != null) {
            sb.append("Statuses: ").append(statuses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statuses":
            return Optional.of(clazz.cast(statuses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeIdFormatResponse> {
        /**
         * <p>
         * Information about the ID format for the resource.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<IdFormat> statuses);

        /**
         * <p>
         * Information about the ID format for the resource.
         * </p>
         * 
         * @param statuses
         *        Information about the ID format for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(IdFormat... statuses);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<IdFormat> statuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdFormatResponse model) {
            statuses(model.statuses);
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            return statuses != null ? statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeIdFormatResponse build() {
            return new DescribeIdFormatResponse(this);
        }
    }
}
